/*
 * Decompiled with CFR 0.152.
 */
package audio;

import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioPlayer {
    private Clip clip;

    public AudioPlayer(String s) {
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(this.getClass().getResource(s));
            this.clip = AudioSystem.getClip();
            this.clip.open(ais);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e1) {
            e1.printStackTrace();
        }
    }

    public void play() {
        if (this.clip == null) {
            return;
        }
        this.stop();
        this.clip.setFramePosition(0);
        this.clip.start();
    }

    public void stop() {
        if (this.clip.isRunning()) {
            this.clip.stop();
        }
    }

    public void close() {
        this.stop();
        this.clip.close();
    }

    public boolean isPlaying() {
        return this.clip.isRunning();
    }

    public void playContinuous() {
        if (this.clip == null) {
            return;
        }
        this.stop();
        this.clip.setFramePosition(0);
        this.clip.loop(-1);
    }
}

